<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Api\AuthController; // Importamos nosso controller
use App\Http\Controllers\Api\Cliente\OportunidadeController;
use App\Http\Controllers\Api\Cliente\InvestimentoController;
use App\Http\Controllers\Api\Cliente\PerfilController;
use App\Http\Controllers\Api\Cliente\FinanceiroController;
use App\Http\Controllers\Api\Cliente\SuporteController;
use App\Http\Controllers\Api\Cliente\IndicacaoController;
use App\Http\Controllers\Api\Admin\UsuarioController;
use App\Http\Controllers\Api\Admin\FinanceiroController;
use App\Http\Controllers\Api\Admin\ConfiguracaoController;
use App\Http\Controllers\Api\Admin\SuporteController;
use App\Http\Controllers\Api\Admin\DashboardController;
use App\Http\Controllers\Api\Admin\ReferenciaController;
use App\Http\Controllers\Api\Admin\ReferenciaController;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
*/

// --- ROTAS PÚBLICAS (Autenticação) ---
// Qualquer um pode acessar
Route::post('/registrar', [AuthController::class, 'registrar']);
Route::post('/login', [AuthController::class, 'login']);


// --- ROTAS PROTEGIDAS (Precisa de Login) ---
// Só usuários com um token válido podem acessar
Route::middleware('auth:sanctum')->group(function () {
		// Rotas de Autenticação Protegidas
	Route::get('/meus-investimentos', [InvestimentoController::class, 'listar']); // Página "Meu Investimento"	
    Route::post('/logout', [AuthController::class, 'logout']);
    Route::get('/meu-perfil', [AuthController::class, 'meuPerfil']);
	Route::get('/meu-painel', [PerfilController::class, 'getDashboardStats']);
	Route::post('/meu-perfil/kyc', [PerfilController::class, 'submitKyc']);
	Route::get('/oportunidades', [OportunidadeController::class, 'listar']); // Página "Gerenciar Caso"
	Route::get('/oportunidades/{id}', [OportunidadeController::class, 'detalhes']); // Detalhes de um caso
	Route:post('/oportunidades/investir', [OportunidadeController::class, 'investir']);
	Route::get('/meus-investimentos', [InvestimentoController::class, 'listar']);
	Route.::get('/minhas-transacoes', [FinanceiroController::class, 'historico']);
	Route::get('/suporte/tickets', [SuporteController::class, 'listarTickets']);
	Route::post('/suporte/tickets/abrir', [SuporteController::class, 'abrirTicket']);
	Route::get('/suporte/tickets/{id}', [SuporteController::class, 'verTicket']);
	Route::post('/suporte/tickets/{id}/responder', [SuporteController::class, 'responderTicket']);
	Route::get('/minhas-indicacoes', [IndicacaoController::class, 'getDetalhes']);
	Route::get('/meu-extrato-lucro', [FinanceiroController::class, 'extratoLucro']);
	Route::post('/deposito/iniciar', [FinanceiroController::class, 'iniciarDeposito']);
	Route::post('/retirada/solicitar', [FinanceiroController::class, 'solicitarRetirada']);
	
	
	// ... (Fim das rotas do Cliente)

// ---------------------------------------------
// --- ROTAS DO PAINEL DE ADMINISTRADOR ---
// ---------------------------------------------
//
// Todas as rotas aqui dentro exigem que o utilizador:
// 1. Esteja logado (middleware 'auth:sanctum')
// 2. Seja um Admin (middleware 'admin' que criámos)
// O prefixo 'admin' significa que as URLs serão /api/admin/usuarios, /api/admin/depositos, etc.

Route::middleware(['auth:sanctum', 'admin'])->prefix('admin')->group(function () {

    // Gestão de Utilizadores
	
    Route::get('/usuarios', [UsuarioController::class, 'listarUsuarios']);
	Route::get('/usuarios/{id}', [UsuarioController::class, 'getUsuarioDetalhes']);
	Route::get('/dashboard', [DashboardController::class, 'getDashboardStats']);
	Route::post('/usuarios/{id}/manage-kyc', [UsuarioController::class, 'manageKyc']);
	Route::get('/transacoes/pendentes', [FinanceiroController::class, 'listarPendentes']);
	Route::post('/transacoes/processar-deposito/{id}', [FinanceiroController::class, 'processarDeposito']);
	Route::post('/transacoes/processar-retirada/{id}', [FinanceiroController::class, 'processarRetirada']);
	Route::get('/configuracoes', [ConfiguracaoController::class, 'getConfiguracoes']);
	Route::post('/configuracoes/salvar', [ConfiguracaoController::class, 'salvarConfiguracoes']);
	Route::get('/suporte/tickets', [SuporteController::class, 'index']); // Listar todos
	Route::get('/suporte/tickets/{id}', [SuporteController::class, 'show']); // Ver 1
	Route::post('/suporte/tickets/{id}/responder', [SuporteController::class, 'responder']); // Admin responde
	Route::post('/suporte/tickets/{id}/fechar', [SuporteController::class, 'fechar']); // Admin fecha
	Route::get('/referencias/comissoes', [ReferenciaController::class, 'listarComissoes']);
	Route::post('/referencias/comissoes/{id}/processar', [ReferenciaController::class, 'processarComissao']);
	Route::get('/referencias/config', [ReferenciaController::class, 'getConfig']);
	Route::post('/referencias/config', [ReferenciaController::class, 'setConfig']);
	Route::get('/referencias/comissoes', [ReferenciaController::class, 'listarComissoes']);
	Route::post('/referencias/comissoes/{id}/processar', [ReferenciaController::class, 'processarComissao']);


	

    // TODO: Adicionar as outras rotas de admin aqui

});


















});