<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Tabela para o gestor de conteúdo (CMS) / Construtor de Páginas
        Schema::create('paginas_cms', function (Blueprint $table) {
            $table->id();
            
            $table->string('titulo');
            
            // A URL da página (ex: "sobre-nos", "termos-de-uso")
            $table->string('slug')->unique(); 
            
            // O conteúdo HTML da página
            $table->longText('conteudo')->nullable();

            // Para o "SEO Manager"
            $table->string('meta_title_seo')->nullable();
            $table->text('meta_description_seo')->nullable();
            
            // Se a página está pública (publicada) ou não (rascunho)
            $table->boolean('publicada')->default(false);

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('paginas_cms');
    }
};