<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Tabela com a troca de mensagens de um ticket
        Schema::create('mensagens_ticket', function (Blueprint $table) {
            $table->id();

            // A qual ticket esta mensagem pertence
            $table->foreignId('ticket_id')
                  ->constrained('tickets_suporte')
                  ->onDelete('cascade');
            
            // Quem enviou a mensagem (pode ser o utilizador ou um admin)
            $table->foreignId('usuario_id')
                  ->constrained('usuarios')
                  ->onDelete('cascade');

            // A mensagem em si
            $table->text('mensagem');
            
            // Se o utilizador/admin anexou um ficheiro (imagem, pdf)
            $table->string('anexo_path')->nullable();

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('mensagens_ticket');
    }
};