<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('tickets_suporte', function (Blueprint $table) {
            $table->id();

            $table->string('ticket_uid')->unique();

            $table->foreignId('usuario_id')
                  ->constrained('usuarios')
                  ->onDelete('cascade');

            $table->string('assunto');

            $table->enum('status', ['aberto', 'respondido', 'fechado'])->default('aberto');
            $table->enum('prioridade', ['baixa', 'media', 'alta'])->default('media');

            $table->timestamp('ultima_resposta_em')->nullable();

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('tickets_suporte');
    }
};