<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Esta tabela guarda o saldo (Equilíbrio) de cada usuário
        Schema::create('carteiras', function (Blueprint $table) {
            $table->id();

            // O dono da carteira (link 1-para-1 com 'usuarios')
            $table->foreignId('usuario_id')
                  ->unique() // Garante que cada usuário só tem UMA carteira
                  ->constrained('usuarios')
                  ->onDelete('cascade'); // Se o usuário for apagado, a carteira também é

            // Saldo que pode ser sacado ou investido (o "Equilíbrio")
            $table->decimal('saldo_disponivel', 15, 2)->default(0.00);

            // Saldo que está em investimentos ativos (não pode ser sacado)
            $table->decimal('saldo_bloqueado', 15, 2)->default(0.00);

            // A tabela 'carteiras' é atualizada com frequência,
            // então é bom ter 'updated_at'
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('carteiras');
    }
};