<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Esta tabela guarda os detalhes EXTRA de uma OPORTUNIDADE
        // que seja do tipo 'imovel'
        Schema::create('oportunidade_meta_imovel', function (Blueprint $table) {
            $table->id();

            // O link 1-para-1 com a tabela principal 'oportunidades'
            $table->foreignId('oportunidade_id')
                  ->unique()
                  ->constrained('oportunidades')
                  ->onDelete('cascade');

            // Campos específicos de Imóveis
            $table->string('tipo_imovel')->nullable(); // Ex: "Apartamento", "Terreno"
            $table->string('localizacao')->nullable();
            $table->integer('numero_quartos')->nullable();
            $table->integer('numero_casas_de_banho')->nullable();
            $table->decimal('area_total', 10, 2)->nullable(); // Ex: 120.50 m²
            
            // O 'valor_meta' na tabela principal pode ser para financiamento,
            // e este o preço total de venda.
            $table->decimal('preco_venda', 15, 2)->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('oportunidade_meta_imovel');
    }
};