<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('perfis_kyc', function (Blueprint $table) {
            $table->id();

            // O dono deste perfil KYC (link 1-para-1)
            $table->foreignId('usuario_id')
                  ->unique() // Cada usuário só tem um perfil KYC
                  ->constrained('usuarios')
                  ->onDelete('cascade'); // Se o usuário for apagado, o KYC dele também é

            // Status da verificação (controlado pelo Admin)
            $table->enum('status_kyc', ['pendente', 'aprovado', 'rejeitado'])->default('pendente');

            // --- Campos para os Documentos ---
            // Tipo de documento que o usuário enviou (Ex: "RG", "CNH", "Passaporte")
            $table->string('documento_tipo')->nullable(); 
            
            // O caminho no servidor onde o ficheiro está guardado
            $table->string('documento_frente_path')->nullable(); 
            $table->string('documento_verso_path')->nullable();
            $table->string('selfie_path')->nullable();
            $table->string('comprovante_residencia_path')->nullable();
            // --- Fim dos Documentos ---

            $table->timestamp('data_submissao')->nullable(); // Quando o usuário enviou os docs
            $table->timestamp('data_revisao')->nullable(); // Quando o admin revisou
            
            // Quem foi o admin que aprovou/rejeitou
            $table->foreignId('revisado_por_admin_id')->nullable()->constrained('usuarios');

            // Motivo da rejeição (para o usuário saber o que corrigir)
            $table->text('notas_rejeicao')->nullable();

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('perfis_kyc');
    }
};