<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // 1. Tabela Principal de Usuários
        Schema::create('usuarios', function (Blueprint $table) {
            $table->id(); // BIGINT, Primary Key, Auto Increment
            $table->string('nome_completo');
            $table->string('email')->unique();
            $table->timestamp('email_verificado_em')->nullable();
            $table->string('senha');
            
            // --- Nossos campos personalizados do ClubGrow ---
            $table->enum('tipo_usuario', ['investidor', 'admin', 'corretor'])->default('investidor');
            $table->enum('status', ['ativo', 'inativo', 'pendente'])->default('pendente');
            
            $table->string('telefone')->nullable();
            $table->timestamp('telefone_verificado_em')->nullable();
            
            // Para o sistema de indicação
            $table->string('codigo_indicacao')->unique()->nullable();
            // Chave estrangeira que aponta para esta mesma tabela
            $table->foreignId('indicado_por_usuario_id')->nullable()->constrained('usuarios')->onDelete('set null');
            
            // Para 2FA (Autenticação de Dois Fatores)
            $table->boolean('usa_2fa')->default(false);
            $table->text('token_2fa_secreto')->nullable();
            // --- Fim dos campos personalizados ---

            $table->rememberToken();
            $table->timestamps(); // created_at e updated_at
        });

        // 2. Tabela de Sessões (Necessária para o Laravel)
        Schema::create('sessions', function (Blueprint $table) {
            $table->string('id')->primary();
            // Aponta para a nossa tabela 'usuarios'
            $table->foreignId('user_id')->nullable()->constrained('usuarios')->onDelete('cascade')->index();
            $table->string('ip_address', 45)->nullable();
            $table->text('user_agent')->nullable();
            $table->longText('payload');
            $table->integer('last_activity')->index();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('sessions');
        Schema::dropIfExists('usuarios');
    }
};