<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class TicketSuporte extends Model
{
    use HasFactory;

    // Informa o nome da tabela
    protected $table = 'tickets_suporte';

    // Campos que podemos preencher em massa
    protected $fillable = [
        'ticket_uid',
        'usuario_id',
        'assunto',
        'status',
        'prioridade',
        'ultima_resposta_em',
    ];

    /**
     * Relação: Um Ticket PERTENCE A UM Utilizador
     */
    public function user()
    {
        return $this->belongsTo(User::class, 'usuario_id');
    }

    /**
     * Relação: Um Ticket TEM MUITAS Mensagens
     */
    public function mensagens()
    {
        return $this->hasMany(MensagemTicket::class, 'ticket_id');
    }
}