<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PerfilKyc extends Model
{
    use HasFactory;

    // Informa o nome da tabela
    protected $table = 'perfis_kyc';

    // Campos que podemos preencher
    protected $fillable = [
        'usuario_id',
        'status_kyc',
        'documento_tipo',
        'documento_frente_path',
        'documento_verso_path',
        'selfie_path',
        'comprovante_residencia_path',
        'data_submissao',
        'data_revisao',
        'revisado_por_admin_id',
        'notas_rejeicao',
    ];

    /**
     * Relação: Um Perfil KYC PERTENCE A UM Utilizador
     */
    public function user()
    {
        return $this->belongsTo(User::class, 'usuario_id');
    }
		/**
	 * Relação: O KYC foi revisado por um Admin (User)
	 */
	public function revisadoPor()
	{
		// belongsTo(Model, 'chave_estrangeira_nesta_tabela')
		return $this->belongsTo(User::class, 'revisado_por_admin_id');
	}
	
}