<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Oportunidade extends Model
{
    use HasFactory;

    // Informa o nome da tabela
    protected $table = 'oportunidades';

    // Campos que podem ser preenchidos (útil para o painel de Admin)
    protected $fillable = [
        'criador_id',
        'tipo_oportunidade',
        'titulo',
        'slug',
        'descricao_curta',
        'imagem_destaque_path',
        'status',
        'valor_meta',
        'valor_arrecadado',
        'data_inicio',
        'data_fim',
    ];

    /**
     * Relação: Uma Oportunidade TEM UM 'meta' de investimento.
     */
    public function metaInvestimento()
    {
        return $this->hasOne(OportunidadeMetaInvestimento::class, 'oportunidade_id');
    }

    /**
     * Relação: Uma Oportunidade TEM UM 'meta' de imóvel.
     */
    public function metaImovel()
    {
        return $this->hasOne(OportunidadeMetaImovel::class, 'oportunidade_id');
    }

    /**
     * Relação: Uma Oportunidade TEM MUITOS 'conteudos' (para as abas).
     */
    public function conteudos()
    {
        return $this->hasMany(OportunidadeConteudo::class, 'oportunidade_id');
    }

    /**
     * Relação: Uma Oportunidade PERTENCE A UM 'criador' (usuário admin).
     */
    public function criador()
    {
        // Usamos 'User::class' (o nosso model de usuário)
        return $this->belongsTo(User::class, 'criador_id');
    }
}