<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class MensagemTicket extends Model
{
    use HasFactory;

    // Informa o nome da tabela
    protected $table = 'mensagens_ticket';

    // Campos que podemos preencher em massa
    protected $fillable = [
        'ticket_id',
        'usuario_id', // Quem enviou a mensagem (cliente ou admin)
        'mensagem',
        'anexo_path',
    ];

    /**
     * Relação: Uma Mensagem PERTENCE A UM Ticket
     */
    public function ticket()
    {
        return $this->belongsTo(TicketSuporte::class, 'ticket_id');
    }

    /**
     * Relação: Uma Mensagem PERTENCE A UM Utilizador (o autor)
     */
    public function user()
    {
        return $this->belongsTo(User::class, 'usuario_id');
    }
}