<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ComissaoIndicacao extends Model
{
    use HasFactory;

    protected $table = 'comissoes_indicacao';

    // *** ADICIONADO ***
    protected $fillable = [
        'usuario_id',
        'indicado_usuario_id',
        'transacao_origem_id',
        'valor_comissao',
        'status',
    ];

    // *** ADICIONADO ***
    protected $casts = [
        'valor_comissao' => 'float',
    ];

    /**
     * Relação: A comissão foi gerada por um Utilizador (o "indicado")
     */
    public function indicado()
    {
        return $this->belongsTo(User::class, 'indicado_usuario_id');
    }

    /**
     * Relação: A comissão foi paga a um Utilizador (o "indicador")
     */
    public function indicador()
    {
        return $this->belongsTo(User::class, 'usuario_id');
    }
}