<?php

namespace App\Http\Controllers\Api\Cliente;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth; // Para pegar o utilizador logado

class InvestimentoController extends Controller
{
    /**
     * Função LISTAR (GET /api/meus-investimentos)
     * Mostra a lista de investimentos que o utilizador JÁ FEZ.
     */
    public function listar(Request $request)
    {
        // Pega o utilizador autenticado
        $user = Auth::user();

        // 1. Busca os investimentos deste utilizador
        // Usamos a relação 'investimentos()' que definimos no Model User
        $investimentos = $user->investimentos()
            ->with([
                // 2. Para cada investimento, busca os detalhes da oportunidade associada
                // Usamos 'oportunidade' (a função que acabámos de criar no Model InvestimentoUsuario)
                // Selecionamos apenas os campos necessários da oportunidade
                'oportunidade:id,titulo,slug,imagem_destaque_path,tipo_oportunidade',
                
                // 3. (Bónus) Buscamos também os detalhes 'meta' dessa oportunidade
                'oportunidade.metaInvestimento', // Traz o ROI, duração, etc.
                'oportunidade.metaImovel'        // Traz quartos, área, etc.
            ])
            ->where('status', 'ativo') // Opcional: mostrar apenas investimentos ativos
            ->orderBy('created_at', 'desc') // Mais recentes primeiro
            ->paginate(10); // Paginação

        // 4. Retorna a lista
        return response()->json($investimentos, 200);
    }
}