<?php

namespace App\Http\Controllers\Api\Cliente;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class IndicacaoController extends Controller
{
    /**
     * Função GET DETALHES (GET /api/minhas-indicacoes)
     * Busca todos os dados para o painel de indicações.
     */
    public function getDetalhes(Request $request)
    {
        $user = Auth::user();

        // 1. O código de indicação do próprio utilizador
        $codigo_indicacao = $user->codigo_indicacao;

        // 2. Estatísticas
        // Total de utilizadores que se registaram com o código dele
        $total_indicados = $user->indicados()->count();
        
        // Total de comissões que ele já recebeu (pagas)
        $total_comissao_paga = $user->comissoes()
                                    ->where('status', 'pago')
                                    ->sum('valor_comissao');
        
        // Total de comissões pendentes de aprovação
        $total_comissao_pendente = $user->comissoes()
                                        ->where('status', 'pendente')
                                        ->sum('valor_comissao');

        // 3. Listas (com paginação)
        
        // Lista de utilizadores indicados
        $lista_indicados = $user->indicados()
                                ->select('id', 'nome_completo', 'email', 'created_at')
                                ->orderBy('created_at', 'desc')
                                ->paginate(10, ['*'], 'page_indicados'); // Paginação nomeada

        // Lista de comissões recebidas
        $lista_comissoes = $user->comissoes()
                                ->with('indicado:id,nome_completo') // Mostra quem gerou a comissão
                                ->orderBy('created_at', 'desc')
                                ->paginate(10, ['*'], 'page_comissoes'); // Paginação nomeada

        // 4. Retorna a resposta
        return response()->json([
            'codigo_indicacao' => $codigo_indicacao,
            'estatisticas' => [
                'total_indicados' => $total_indicados,
                'total_comissao_paga' => (float) $total_comissao_paga,
                'total_comissao_pendente' => (float) $total_comissao_pendente,
            ],
            'lista_indicados' => $lista_indicados,
            'lista_comissoes' => $lista_comissoes,
        ], 200);
    }
}