<?php
namespace App\Http\Controllers\Api\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Configuracao;

class ConfiguracaoController extends Controller
{
    /**
     * Busca TODAS as configurações (para o React preencher o formulário)
     * (GET /api/admin/configuracoes)
     */
    public function getConfiguracoes()
    {
        // Retorna as configurações como um objeto {chave: valor}
        $configs = Configuracao::all()->pluck('valor', 'chave');
        return response()->json($configs, 200);
    }

    /**
     * Salva as configurações (o frontend envia TUDO de volta)
     * (POST /api/admin/configuracoes/salvar)
     */
    public function salvarConfiguracoes(Request $request)
    {
        // O request virá como:
        // { "index_titulo": "Novo Título", "index_subtitulo": "Novo Subtítulo" }
        
        foreach ($request->all() as $chave => $valor) {
            Configuracao::updateOrCreate(
                ['chave' => $chave], // Onde encontrar
                ['valor' => $valor]  // O que atualizar ou criar
            );
        }

        return response()->json(['message' => 'Configurações salvas com sucesso!'], 200);
    }
}